#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QNetworkReply>

QT_BEGIN_NAMESPACE
namespace Ui {
class MainWindow;
}
QT_END_NAMESPACE

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = nullptr);
    ~MainWindow();

private slots:
    void onDataReceived();
    void fetchConversionData(QString &, QString &);
    void on_btnGetRate_clicked();

private:
    Ui::MainWindow *ui;
    QStringList countryList;
    void prePareCountriesList();
    void populateCountriesList();
    QNetworkAccessManager * manager;
    QNetworkReply *reply;
};
#endif // MAINWINDOW_H
